<?php

namespace App\Http\Middleware;

use App\Models\Session;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class RateLimitLocationUpdates
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $publicId = $request->route('publicId');
        $session = Session::where('public_id', $publicId)->first();
        
        if ($session && $session->last_updated) {
            $secondsSinceLastUpdate = $session->last_updated->diffInSeconds(now());
            
            if ($secondsSinceLastUpdate < 10) {
                return response()->json([
                    'error' => 'Location updates must be at least 10 seconds apart',
                    'retryAfter' => 10 - $secondsSinceLastUpdate
                ], 429);
            }
        }
        
        return $next($request);
    }
}
