# Dima M3ak Web Interface

A beautiful, responsive web interface for viewing live location sharing sessions with Google Maps integration.

## Features

- **Live Location Tracking**: Real-time location updates every 5 seconds
- **Google Maps Integration**: Interactive map with custom markers
- **History Visualization**: Display complete location history as a path
- **Battery Status**: Show device battery level with color-coded markers
- **Responsive Design**: Works on desktop and mobile devices
- **Session Management**: Load, track, and stop location sessions

## Setup

### 1. Get Google Maps API Key

1. Go to [Google Cloud Console](https://console.cloud.google.com/)
2. Create a new project or select existing one
3. Enable the Maps JavaScript API
4. Create credentials (API Key)
5. Restrict the API key to your domain for security

### 2. Configure the Interface

Edit `public/index.html` and replace `YOUR_GOOGLE_MAPS_API_KEY` with your actual API key:

```html
<script async defer 
    src="https://maps.googleapis.com/maps/api/js?key=YOUR_ACTUAL_API_KEY&callback=initMap">
</script>
```

### 3. Start the Server

```bash
php artisan serve
```

Visit `http://localhost:8000` to access the interface.

## Usage

### 1. Load a Session

1. Copy the viewer URL from the API response when creating a session
2. Paste it into the "Viewer URL" field
3. Click "Load Session"

### 2. Start Live Tracking

1. After loading a session, click "Start Live Tracking"
2. The map will update every 5 seconds with the current location
3. Battery level is shown with color-coded markers:
   - Green: Battery > 20%
   - Red: Battery ≤ 20%

### 3. View History

1. Click "Load Full History" to see the complete path
2. Use "Show Path" / "Hide Path" to toggle history display
3. The path is shown as a red polyline on the map

### 4. Stop Tracking

Click "Stop Tracking" to stop live updates.

## Interface Elements

### Sidebar Controls

- **Viewer URL**: Input field for the signed viewer URL
- **Load Session**: Load and validate the session
- **Start Live Tracking**: Begin real-time updates
- **Stop Tracking**: Stop live updates
- **Session Info**: Display current status, battery, last update, and expiry
- **History Controls**: Toggle and load location history

### Map Features

- **Current Location Marker**: Custom circular marker with battery color
- **History Path**: Red polyline showing the complete route
- **Info Windows**: Click markers for detailed information
- **Auto-fit**: Map automatically adjusts to show the full path

## Customization

### Styling

The interface uses CSS custom properties and can be easily customized:

```css
:root {
    --primary-color: #667eea;
    --secondary-color: #764ba2;
    --success-color: #4CAF50;
    --danger-color: #F44336;
}
```

### Map Styling

Google Maps styling can be modified in the `initMap()` function:

```javascript
map = new google.maps.Map(document.getElementById('map'), {
    zoom: 15,
    center: { lat: 40.7128, lng: -74.0060 },
    mapTypeId: 'roadmap',
    styles: [
        // Add custom map styles here
    ]
});
```

### Update Frequency

Change the tracking interval in the `startTracking()` function:

```javascript
// Update every 3 seconds instead of 5
trackingInterval = setInterval(updateLocation, 3000);
```

## Security Notes

1. **API Key Security**: Always restrict your Google Maps API key to specific domains
2. **HTTPS**: Use HTTPS in production for secure communication
3. **CORS**: The API endpoints are configured to allow cross-origin requests

## Browser Compatibility

- Chrome 60+
- Firefox 55+
- Safari 12+
- Edge 79+

## Mobile Support

The interface is fully responsive and works on:
- iOS Safari
- Android Chrome
- Mobile Firefox
- Other modern mobile browsers

## Troubleshooting

### Common Issues

1. **Map not loading**: Check your Google Maps API key and ensure Maps JavaScript API is enabled
2. **CORS errors**: Make sure the Laravel backend is running and CORS is configured
3. **Session not loading**: Verify the viewer URL is correct and the session is still active
4. **History not showing**: Check if the session has location history data

### Debug Mode

Open browser developer tools to see console logs and network requests for debugging.

## Performance

- **Efficient Updates**: Only updates when location changes
- **Optimized Rendering**: Uses Google Maps optimized rendering
- **Memory Management**: Properly cleans up markers and polylines
- **Responsive Design**: Adapts to different screen sizes

## Future Enhancements

Potential improvements:
- WebSocket support for real-time updates
- Offline map caching
- Export location data
- Multiple session support
- Custom map themes
- Location sharing via QR codes
